;CloudMax's Extended Item Action Table
;This will cause the game to load the Item Action Table from 0x803F53F0 instead of 0x803F403C.
.org 0x803D38F0
	LUI		V0, 0x803F		;V0 = 0x803F0000
	ADDU	V0, V0, A0		;V0 = 0x803F0000 + Item ID
	JR		RA
	LB		V0, 0x53F0(V0)	;V0 = Action ID

;CloudMax's Custom Action Engine Alpha v1.2
;You do not have to touch anything above the functions section.
;I've prepared 2 example actions:
;1 for Iron & Hover Boots (Action ID 43 & 44)
;This function will equip the specified boots, unless you already have them equipped, if that's the case, you will unequip them. It costs 2 magic to use.
;1 for Quiver, Bullet Bag & Bomb Bag (Action ID 45 to 4D)
;This function will turn the items into portable bags with ammo for the 3 different items that when used will give you the amount that specific quiver/bag can carry. It will cost 5 rupees to use.
;
;A basic Action would look something like this:
;customaction1:   
;   ;Setup Start (Setup is optional, if item doesn't have any requirements, just skip it)
;   ADDIU T1, R0, 0x0001       ;Magic Required: 0x1 (You need at least 1 magic to use the item)
;   ADDIU T2, R0, 0x0001       ;Magic Cost: 0x1 (Using the item will cost you 1 magic)
;   ADDIU T3, R0, 0x0001       ;Ammo Cost: 0x1 (It cost 1 ammo to use the item. If the item slot doesn't have ammo, it will not be usable)
;   ADDIU T4, R0, 0x0001       ;Health Required: 0x1 (You need at least 1 health to use the item)
;   ADDIU T5, R0, 0x0001       ;Rupee Cost: 0x1 (It'll cost you 1 rupee to use the item)
;   ADDIU T6, R0, 0x0002       ;Restriction: 0x2 (Item can only be used while standing)
;   JALR AT, V0                ;Run the setup
;   NOP
;   ;Setup End
;   ...
;   ASM Code for the specified Action
;   ... 
;   J end                      ;Function is over, jump to end
;   ADDIU A1, R0, 0x0835       ;Set sound to play to 0x0835 (Pull out Item)
;
	
;Is in ovl_player_actor
.org 0x803D63EC
    J start
	NOP
	mask:
	LBU		T0, 0x015F(A3)		;T0 = Current Mask
	ADDIU	T1, A2, 0xFFC7		;T1 = Mask you're equipping (Action ID-0x39)
	BEQL	T0, T1, unequip		;Branch Likely if the mask you're using the mask you have equipped
		SB		R0, 0x015F(A3)		;Unequip mask you have equipped
	SB		T1, 0x015F(A3)		;Equip mask you're using
	unequip:
	
.org 0x803D6410
	return:
	
;Is in custom
.org 0x80500000
start:
    SLTI T0, A2, 0x43          ;Set T0 if A2 is less than 0x43
    BEQ T0, R0, setup          ;Branch if action is NOT less than 0x43
    NOP                   
    J mask                     ;Jump to the Mask function
    NOP
end:
	LUI		A0, 0x8022			;A0 = 0x80220000
    JAL		0x803D2A8C          ;Play sound
    ORI		A0, A0, 0x45B0		;A0 = 0x802245B0
    J return               		;
    NOP							;
	;same?
unusable:
    J end                      ;Jump to End
    ADDIU A1, R0, 0x4806       ;Set sound to play to Unusable Item
setup:
    ;V1 = 0x8015E660 (SRAM Address)
    ;A2 = Action ID
    ;RA = Default Return Address, do not change unless you know what you're doing
    LI RA, end                 ;Set RA to end so that it can be used at the end of a function.
    ADDU T1, R0, R0            ;Clear T1 for function setups
    ADDU T2, R0, R0            ;Clear T2 for function setups
    ADDU T3, R0, R0            ;Clear T3 for function setups
    ADDU T4, R0, R0            ;Clear T4 for function setups
    ADDU T5, R0, R0            ;Clear T5 for function setups
    ADDU T6, R0, R0            ;Clear T6 for function setups
    ADDU T7, R0, R0            ;Clear T7 for function setups
    ;Used:
    ;S0, S2, S3
    ;Unused:
    ;S1
    LI V0, verify              ;Prepare V0 for function setup verification
    B functions                ;Jump to functions
    NOP
verify:
    ;AT = Return Address       Address to return to after verifying the item.
    ;T1 = Magic Required       You need atleast this much magic to use it.
    ;T2 = Magic Cost           This is the amount of magic it'll cost when using it. This'll be the required amount if it is higher than T1.
    ;T3 = Ammo Cost            The amount of Ammo you need to use the item, you'll also loose the same amount. (ONLY WORKS FOR ITEMS WITH AMMO)
    ;T4 = Health Required      The amount of health you need to use the item.
    ;T5 = Rupee Cost           The amount of rupees it'll cost to use the item.
    ;T6 = Restriction          Decides when an item CAN'T be used. 0x1 = Standing, 0x2 = Midair
    ;     These bitflags will disable the item even if the button isn't. The default restrictions are still applied. items can't be used from ledges, climbable collision, rolling, etc.
    ;T7                        Unused
    ;T8                        Unused
    ;T9                        Unused
    ;V0                        Used for verification
    ;V1 = 0x8015E660           SRAM Address
    
    ;Check health
    LH V0, 0x0030(V1)          ;V0 = Current Health
    SLT V0, V0, T4             ;If (Current Health < Health Required) {V0 = 0x1} Else {V0 = 0x0}
    BNE V0, R0, unusable       ;Branch to unusable if you do not have enough health
    NOP
    ;T4, V0 is now available
    
    ;Check Magic
    LB V0, 0x0033(V1)          ;V0 = Current Magic
    SLT T4, V0, T1             ;If (Current Magic < Magic Required) {T4 = 0x1} Else {T4 = 0x0}
    BNE T4, R0, unusable       ;Branch to unusable if you do not have enough magic
    NOP
    SUB T1, V0, T2             ;T1 = V0 - T2 (New Magic)
    BLTZ T1, unusable          ;Branch to unusable if you do not have enough magic
    NOP
    ;T2, T4, V0 is now unused
    
    ;Check Rupees
    LH V0, 0x0034(V1)          ;V0 = Current Rupees
    SUB V0, V0, T5             ;V0 = V0 - T5 (New Rupees)
    BLTZ V0, unusable          ;Branch to unusable if you do not have rupees
    NOP
    SUB T5, R0, T5             ;T5 = -T5 (Rupees to decrease by)
    ;T2, T4, V0 is now unused
    
	
    ;Get Item Slot
    ;To do this, we'll have to read the Last Pressed Item Button Index from 0x801DAB70
    ;Then we use that ID to get the item slot linked to the specified button.
    LUI V0, 0x8022				;V0 = Last Pressed Item Button Index Address (Upper Bytes)
    LB V0, 0x4700(V0)			;V0 = Last Pressed Item Button Index
    ADDU V0, V1, V0            ;V0 = SRAM + Last Pressed Item Button Index
    LB V0, 0x006B(V0)          ;V0 = Item Slot ID
    ;V0 won't be changed for the rest of the verification so that the item slot can be easily accessed later on
	
    ;Check Ammunition
    ;IF the item requires ammunition, we make sure that the slot ID has a value below 14
    ;(so that it won't attempt to read incorrect data, only slot 0-13 has ammo)
    ;If the action requires Ammo, but the item slot doesn't have ammo, the item won't be usable in order to prevent data manipulation.
    ;If it passes the check we look up how much Ammo the item has and continue like normally.
	BEQ T3, R0, skipammo		;We branch past the ammo check if it doesn't cost any ammo
    SLTI T2, V0, 0x0014        ;If (Item Slot ID < 0x0014) {T2 = 0x1} Else {T2 = 0x0}
    BEQ T2, R0, unusable       ;Branch to unusable if the Item Slot ID isn't below 14
    NOP
    ADDU T2, V1, V0            ;T2 = SRAM + Item Slot ID
    LB T2, 0x008C(T2)          ;T2 = Ammo
    SUB T3, T2, T3             ;T3 = Ammo - Ammo Cost
    BLTZ T3, unusable          ;Branch to unusable if you do not have enough ammo
    NOP
	skipammo:
    ;T2, T4 is now unused
    
    ;Check Restriction
    ;0x801DAAB8 = Standing, In Water, Jumping up against ledge, etc. State
    ;0x1 = Standing
    ;0x60 = In Water?
    BEQ T6, R0, verresqu       ;There is no restriction, skip past the check
    NOP
    LUI T4, 0x8022             ;T4 = standing & in water state (Upper bytes)
    LH T4, 0x4638(T4)          ;T4 = Current standing & in water state
    verresstand:
    ANDI T2, T6, 0x0001        ;T2 = 0x1 if Standing is restricted
    BEQ T2, R0, verresair      ;Branch to midair check if standing isn't restricted
    NOP
    ANDI T2, T4, 0x0001        ;T2 = 0x1 if you're standing
    BNE T2, R0, unusable       ;Branch to unusable if you're standing
    NOP
    verresair:
    ANDI T2, T6, 0x0002        ;T2 = 0x2 if being in midair is restricted
    BEQ T2, R0, verresqu       ;Branch to restriction check end if being in midair isn't restricted
    NOP
    ANDI T2, T4, 0x0001        ;T2 = 0x1 if you're standing
    BEQ T2, R0, end            ;Branch to end if you're not standing
    ADDU A1, R0, R0            ;Set sound to play to nothing
    verresqu:
    ;T2, T4, T6 is now unused

    ;Update
    ;T1 = New Magic Amount
    ;T2 = Unused
    ;T3 = New Ammo Amount
    ;T4 = Unused
    ;T5 = Amount of rupees to decrease by
    ;T6 = Unused
    ;T7 = Unused
    ;T8 = Unused
    ;T9 = Unused
    ;V0 = Item Slot ID
    ;V1 = SRAM Address
    
    SB T1, 0x0033(V1)           ;Current Magic = New Magic Amount
    
    LH T2, 0x13CC(V1)           ;Load current rupee increase/decrease amount
    ADDU T2, T2, T5             ;Set new rupee increase/decrease amount
    SH T2, 0x13CC(V1)           ;Store new rupeee increase/decrease amount
    
    ADDU T2, V1, V0             ;T2 = SRAM + Item Slot ID
    SB T3, 0x008C(T2)           ;Current Ammo = New Ammo Amount
    
    LI RA, end                  ;Set RA to end so that it can be used at the end of a function.
    JR AT                       ;Jump Back
    NOP
functions:
    SLTI T0, A2, 0x45           ;Set T0 if A2 is less than 0x45
    BNE T0, R0, boots           ;Branch to boots if action is less than 0x45
    NOP
    SLTI T0, A2, 0x4E           ;Set T0 if A2 is less than 0x4E
    BNE T0, R0, refill          ;Branch to refill if action is less than 0x4E
    NOP
	ADDIU T0, R0, 0x4E			;T0 = 0x4E
	BEQ A2, T0, escaperope		;Branch to escaperope if action is 0x4E
    NOP
	ADDIU T0, R0, 0x4F			;T0 = 0x4F
	BEQ A2, T0, testactor		;Branch to testactor if action is 0x4F
	NOP
    B end                      ;Branch to end if action doesn't exist
    NOP
boots:
    ;Setup Start
    ADDIU T2, R0, 0x0002       ;Magic Cost: 0x2
    JALR AT, V0                ;Verify that you can use the item
    NOP
    ;Setup End
    ADDIU T0, A2, 0xFFBE       ;T0 = A2 - 0x42 = New Boots
    LUI T1, 0x8022             ;Boot Type Address (Upper Bytes)
    LB A1, 0x46FF(T1)          ;A1 = Current Boots
    BEQL A1, R0, updatespeed   ;Execute Delay Slot and Branch if you don't have any boots equipped
        SB T0, 0x46FF(T1)      ;Current Boots = T0
    SB R0, 0x46FF(T1)          ;Current Boots = None
    updatespeed:
    LI A1, 0x802245B0          ;Required Argument
    JAL 0x8008E750             ;Movement Speed Update Function
    NOP
    J end                      ;Function is over, jump to end
    ADDIU A1, R0, 0x0835       ;Set sound to play to Pull out Item
refill:   
    ;Setup Start 
    ADDIU T5, R0, 0x0005       ;Rupee Cost: 0x5
    ADDIU T6, R0, 0x0002       ;Item can't be used while in midair
    JALR AT, V0                ;Verify that you can use the item
    NOP
    ;Setup End
    ADDIU T0, A2, 0xFFBC       ;T0 = A2 - 0x44 = Type (1 to 9)
    ADDIU A1, R0, 0x0002       ;A1 = 0x2
    MULTU T0, A1               ;LO = T0 * 0x2
    MFLO T1                    ;T1 = LO (Offset used to get upgrade size)
    LUI A1, 0x8012             ;A1 = 0x80120000 (Capacity Offset Upper Byte)
    OR A1, A1, T1              ;A1 = Capacity Global Offset
    SLTIU T1, T0, 0x0004       ;If T0 < 0x4 Then T1 = 1 Else T1 = 0
    BEQL T1, R0, quiver        ;Branch Likely if T0 isn't below 0x4
        SLTIU T1, T0, 0x0007   ;If T0 < 0x7 Then T1 = 1 Else T1 = 0
    ADDIU A0, R0, 0x0006       ;Slingshot
    J setammo
    LH A1, 0x7224(A1)          ;A1 = Bullet Bag Capacity Amount
    quiver:
    BEQ T1, R0, bombbag        ;Branch Likely if T0 isn't below 0x7
    ADDIU A0, R0, 0x0003       ;Bow
    J setammo
    LH A1, 0x71FC(A1)          ;A1 = Quiver Capacity Amount
    bombbag:
    ADDIU A0, R0, 0x0002       ;Bomb
    LH A1, 0x7204(A1)          ;A1 = Bomb Bag Capacity Amount
    setammo:
    JAL 0x80087330             ;Jump to set Item Amount
    NOP
	LI A0, 0x80212020          ;A0 = 0x80212020 (Required Parameter)
	ADDIU A1, R0, 0x00FF       ;A1 = 0xFF (Blank)
	LUI A2, 0x8022             ;A2 = Last Pressed Item Button Index Address (Upper Bytes)
	JAL 0x80086B9C             ;Jump to Set Item (Using Button Index)
    LB A2, 0x4700(A2)          ;A2 = Last Pressed Item Button Index
    J end                      ;Function is over, jump to end
    ADDIU A1, R0, 0x0835       ;Set sound to play to Pull out Item
escaperope:
    ;Setup Start 
    ADDIU T6, R0, 0x0002       ;Item can't be used while in midair
    JALR AT, V0                ;Verify that you can use the item
    NOP
    ;Setup End
	LW T9, 0x0014(SP)			;
	SW T9, 0x8000(SP)			;
	LI T0, 0x802245B0			;T0 = Pointer to Links Position
	LWC1 F4, 0x0024(T0)			;Link X Coord
	LWC1 F8, 0x0028(T0)			;Link Z Coord
	LWC1 F6, 0x002C(T0)			;Link Y Coord
	MFC1 A3, F4					;A3 = F4 (Link X Coord)
	SWC1 F8, 0x0010(SP)			;Stack Var 2 = F8 (Link Z Coord)
	SWC1 F6, 0x0014(SP)			;Stack Var 1 = F6 (Link Y Coord)
	SW R0, 0x0018(SP)			;X Rot
	SW R0, 0x001C(SP)			;Y Rot
	SW R0, 0x0020(SP)			;Z Rot
	ADDIU T1, R0, 0x0000		;Set actor variables to 0x0001
	SW T1, 0x0024(SP)			;Set actor Variables to T1
	LI A0, 0x80213C44			;A0 = 0x80213C44 (Required Argument)
	LI A1, 0x80212020			;A1 = 0x80212020 (Required Argument)
	JAL 0x80031F50				;Jump to Spawn Actor
	ADDIU A2, R0, 0x005D		;A2 = 0x009E (Farore's Wind)
	
	ADDIU T0, R0, 0x0014		;T0 = 0x0014
	SB T0, 0xF885(S0)			;Activate warp
	
	LW T9, 0x8000(SP)			;
	SW T9, 0x0014(SP)			;
	J end						;Function is over, jump to end
    ADDIU A1, R0, 0x087A		;Set sound to play to farore's wind
testactor:
    ;Setup Start 
    ADDIU T3, R0, 0x0001       ;Ammo Cost: 0x1
    JALR AT, V0                ;Verify that you can use the item
    NOP
    ;Setup End
	LW T9, 0x0014(SP)			;
	SW T9, 0x8000(SP)			;
	LI T0, 0x802245B0			;T0 = Pointer to Links Position
	LWC1 F4, 0x0024(T0)			;Link X Coord
	LWC1 F8, 0x0028(T0)			;Link Z Coord
	LWC1 F6, 0x002C(T0)			;Link Y Coord
	MFC1 A3, F4					;A3 = F4 (Link X Coord)
	SWC1 F8, 0x0010(SP)			;Stack Var 2 = F8 (Link Z Coord)
	SWC1 F6, 0x0014(SP)			;Stack Var 1 = F6 (Link Y Coord)
	SW R0, 0x0018(SP)			;X Rot
	SW R0, 0x001C(SP)			;Y Rot
	SW R0, 0x0020(SP)			;Z Rot
	ADDIU T1, R0, 0x00000		;
	;ADDIU T1, R0, 0x0202		;T1 = 0x0202
	SW T1, 0x0024(SP)			;Aet Action Variables to T1
	LI A0, 0x80213C44			;A0 = 0x80213C44 (Required Argument)
	LI A1, 0x80212020			;A1 = 0x80212020 (Required Argument)
	JAL 0x80031F50				;Jump to Spawn Actor
	ADDIU A2, R0, 0x01A0		;A2 = 0x01A0 (Crate)
	;ADDIU A2, R0, 0x0000		;A2 = 0x0000 (Links Actor ID)
	LW T9, 0x8000(SP)			;
	SW T9, 0x0014(SP)			;
	J end						;Function is over, jump to end
    ADDIU A1, R0, 0x0835		;Set sound to play to Pull out Item
	
	
	
	
80223E08 decides which Link you spawn as.
	
	
Spawn Actor
A0 = 80213C44
A1 = 80212020
A2 = Actor ID
Stack = floating point x, y, z position, Half-float x,y,z rotation, actor variable